/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.hipstershop.provider;

import com.alibabacloud.hipstershop.CartItem;
import com.alibabacloud.hipstershop.CartService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(version="1.0.0")
public class CartServiceImpl
implements CartService {
    private static final Logger logger = LoggerFactory.getLogger(CartServiceImpl.class);
    private ConcurrentHashMap<String, List<CartItem>> cartStore = new ConcurrentHashMap();

    public List<CartItem> viewCart(String userID) {
        return this.cartStore.getOrDefault(userID, Collections.emptyList());
    }

    public boolean addItemToCart(String userID, String productID, int quantity) {
        List itemList = this.cartStore.computeIfAbsent(userID, k -> new ArrayList());
        for (CartItem item : itemList) {
            if (!item.productID.equals(productID)) continue;
            item.quantity += quantity;
            return true;
        }
        itemList.add(new CartItem(productID, quantity));
        return true;
    }

    public boolean emptyCart(String userID) {
        this.cartStore.clear();
        return true;
    }
}

