/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.hipstershop.utils;

import com.alibabacloud.hipstershop.utils.AdjustableSemaphore;
import com.google.common.base.MoreObjects;

public final class AdjustableSemaphore {
    private final ResizeableSemaphore semaphore = new ResizeableSemaphore();
    private volatile int maxPermits = 0;

    public AdjustableSemaphore() {
    }

    public AdjustableSemaphore(int maxPermits) {
        if (maxPermits < 0) {
            throw new IllegalArgumentException("maxPermits must be a non-negative value");
        }
        if (maxPermits > 0) {
            this.setMaxPermits(maxPermits);
        }
    }

    public int maxPermits() {
        return this.maxPermits;
    }

    public synchronized void setMaxPermits(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + newMax);
        }
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            delta = -delta;
            this.semaphore.reducePermits(delta);
        }
        this.maxPermits = newMax;
    }

    public void release() {
        this.semaphore.release();
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public boolean tryAcquire() {
        return this.semaphore.tryAcquire();
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("semaphore", (Object)this.semaphore).add("maxPermits", this.maxPermits).toString();
    }
}

