/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.hipstershop.web;

import com.alibabacloud.hipstershop.CartItem;
import com.alibabacloud.hipstershop.dao.CartDAO;
import com.alibabacloud.hipstershop.dao.ProductDAO;
import com.alibabacloud.hipstershop.domain.Product;
import com.alibabacloud.hipstershop.utils.AdjustableSemaphore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.RedirectView;

@RefreshScope
@Controller
public class AppController {
    @Autowired
    private ProductDAO productDAO;
    @Autowired
    private CartDAO cartDAO;
    private Random random = new Random(System.currentTimeMillis());
    private String userID = "Test User";
    private long checkInterval = 20000L;
    private long overTime = 200L;
    private long threadsTargetReachTime = 600000L;

    @GetMapping(value={"/"})
    public String index(Model model) {
        model.addAttribute("products", (Object)this.productDAO.getProductList());
        return "index.html";
    }

    @ResponseBody
    @GetMapping(value={"/product/buy/{requestTotal}/{threadNum}"})
    public String buy(@PathVariable(name="requestTotal") int requestTotal, @PathVariable(name="threadNum") int threadNum) {
        int checkThread = 1;
        long startTime = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum + checkThread);
        CountDownLatch countDownLatch = new CountDownLatch(requestTotal + checkThread);
        AtomicInteger maxPermit = new AtomicInteger(threadNum / 2);
        AtomicInteger count = new AtomicInteger(0);
        AdjustableSemaphore adjustableSemaphore = new AdjustableSemaphore(maxPermit.get());
        AtomicInteger num = new AtomicInteger(0);
        AtomicInteger errNum = new AtomicInteger(0);
        ArrayList errCountList = new ArrayList();
        executorService.execute(() -> {
            int oldErrNum = 0;
            while (countDownLatch.getCount() > (long)threadNum) {
                try {
                    Thread.sleep(this.checkInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int currentOverTimeNum = errNum.get();
                errCountList.add(currentOverTimeNum - oldErrNum);
                oldErrNum = currentOverTimeNum;
                if (maxPermit.get() < threadNum) {
                    maxPermit.set(maxPermit.addAndGet(threadNum / 2 / (int)(this.threadsTargetReachTime / this.checkInterval)));
                    adjustableSemaphore.setMaxPermits(maxPermit.get());
                    continue;
                }
                maxPermit.set(threadNum);
                adjustableSemaphore.setMaxPermits(threadNum);
            }
            if (oldErrNum != errNum.get()) {
                errCountList.add(errNum.get() - oldErrNum);
            }
            countDownLatch.countDown();
        });
        for (int i = 0; i < requestTotal; ++i) {
            executorService.execute(() -> {
                int current = num.getAndIncrement();
                try {
                    adjustableSemaphore.acquire();
                    String backEndCost = this.productDAO.buy(current);
                    adjustableSemaphore.release();
                    count.getAndIncrement();
                    if (count.get() == maxPermit.get()) {
                        count.set(0);
                    }
                    if (Long.parseLong(backEndCost) > this.overTime) {
                        errNum.getAndIncrement();
                    }
                    System.out.println("current concurrency " + count.get() + " max concurrency " + maxPermit.get() + " for " + current + " cost " + Long.parseLong(backEndCost));
                }
                catch (Exception e) {
                    System.out.println("error for :" + String.valueOf(current));
                    errNum.getAndIncrement();
                }
                countDownLatch.countDown();
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
        long endTime = System.currentTimeMillis();
        return this.printResult(requestTotal, requestTotal - errNum.get(), errCountList, endTime - startTime);
    }

    private String printResult(int totalCount, int successCount, List<Integer> overtimeList, long costTime) {
        String result = "<pre>total " + totalCount + " success " + successCount + " timeOutCount " + (totalCount - successCount) + " timeOutStandard " + this.overTime + " cost " + costTime + "</pre>";
        for (int i = 0; i < overtimeList.size(); ++i) {
            result = result + "<pre>" + (long)i * this.checkInterval / 1000L + "s - " + (long)(i + 1) * this.checkInterval / 1000L + "s timeOut: " + overtimeList.get(i) + "</pre>";
        }
        System.out.println(result);
        return result;
    }

    @ResponseBody
    @PostMapping(value={"/cart/checkout"})
    public String checkout() {
        return "not support yet";
    }

    @PostMapping(value={"/cart/empty"})
    public RedirectView empty() {
        this.cartDAO.emptyCart(this.userID);
        return new RedirectView("/cart");
    }

    @GetMapping(value={"/product/{id}"})
    public String product(@PathVariable(name="id") String id, Model model) {
        Product p = this.productDAO.getProductById(id);
        model.addAttribute("product", (Object)p);
        return "product.html";
    }

    @GetMapping(value={"/cart"})
    public String viewCart(Model model) {
        List items = this.cartDAO.viewCart(this.userID);
        for (CartItem item : items) {
            Product p = this.productDAO.getProductById(item.productID);
            item.productName = p.getName();
            item.price = p.getPrice();
            item.productPicture = p.getPicture();
        }
        model.addAttribute("items", (Object)items);
        return "cart.html";
    }

    @PostMapping(value={"/cart"})
    public RedirectView addToCart(@RequestParam(name="product_id") String productID, @RequestParam(name="quantity") int quantity) {
        this.cartDAO.addToCart(this.userID, productID, quantity);
        return new RedirectView("/cart");
    }

    @ModelAttribute(value="cartSize")
    public int getCartSize() {
        return this.cartDAO.viewCart(this.userID).size();
    }
}

